//----------------------------------------------------------------------------//
//- CadBasisErfassen.pas -----------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Abstrakte Basisklasse TDlgBasisErfassen                                    //
//                                                                            //
// Diese Klasse kapselt ein Formular mit allen Eigenschaften, die bei den     //
// Erfassen- und Editierendialogen gleich sind.                               //
// Die Erfassen- und Editierdialoge werden von hier abgeleitet                //
// Dialog darf nicht instanziert werden, aus diesem Grund existiert keine     //
// globale Variable DlgBasisErfassen.                                         //
//----------------------------------------------------------------------------//

unit CadBasisErfassen;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, StdCtrls, ExtCtrls;

//------------------------------------------------------------------------------

type
  TDlgBasisErfassen = class(TCaDlgBaseDialog)
    m_BtnWeitere    : TButton;
    m_PanSeparator  : TPanel;

    //--------------------------------------------------------------------------

    procedure FormShow(Sender: TObject);
  private

  //----------------------------------------------------------------------------

  protected
    m_sTitelNeu,
    m_sTitelBearbeiten,
    m_sTitelKopieren     : String;
    m_iModus             : Integer;

    //--------------------------------------------------------------------------

    procedure PrtSetTitles; virtual; abstract;

  //----------------------------------------------------------------------------

  public
    function ShowModal(iMode: Integer): Integer; reintroduce;
  end; // TDlgBasisErfassen

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CaoCheck, CamConst;

//------------------------------------------------------------------------------

function TDlgBasisErfassen.ShowModal(iMode: Integer): Integer;
begin
  m_iModus := iMode;
  Result := inherited ShowModal;
end; // TDlgBasisErfassen.ShowModal

//------------------------------------------------------------------------------

procedure TDlgBasisErfassen.FormShow(Sender: TObject);
begin
  inherited;
  PrtSetTitles;
  m_obCaoCheck.InitEditsInForms(TForm(Self));
  // Den Titel des Dialogs setzen
  case m_iModus of
    c_iModusNeu :
    begin
      Self.Caption           := m_sTitelNeu;
      m_BtnWeitere.Visible   := True;
    end; //  c_iModusNeu
    c_iModusEdit:
    begin
      Self.Caption         := m_sTitelBearbeiten;
      m_BtnWeitere.Visible := False;
    end; // c_iModusEdit
    c_iModusCopy:
    begin
      Self.Caption         := m_sTitelKopieren;
      m_BtnWeitere.Visible := False;
    end; // c_iModusCopy
  end; // case
  m_PanSeparator.Visible := m_BtnWeitere.Visible;  
end;

//------------------------------------------------------------------------------

end.
